/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xapp;

import uk.co.demon.obelisk.xapp.Option;

public abstract class Application {
    private static Application application = null;
    private Option helpOption = new Option("-help", "Displays help information");
    private String[] arguments = null;
    private boolean finished = false;

    public static Application getApplication() {
        return application;
    }

    public void run(String[] arguments) {
        this.arguments = Option.processOptions(arguments);
        this.startUp();
        while (!this.finished) {
            this.execute();
        }
        this.cleanUp();
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void setFinished(boolean finished) {
        this.finished = finished;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.toDebug() + "]";
    }

    protected Application() {
        application = this;
    }

    protected void startUp() {
        if (this.helpOption.isPresent()) {
            System.err.println("Usage:\n    java " + this.getClass().getName() + Option.listOptions() + this.describeArguments());
            System.err.println();
            System.err.println("Options:");
            Option.describeOptions();
            System.exit(1);
        }
    }

    protected abstract void execute();

    protected void cleanUp() {
    }

    protected String describeArguments() {
        return "";
    }

    protected final String[] getArguments() {
        return this.arguments;
    }

    protected String getSystemPreferencesRoot() {
        return null;
    }

    protected String getUserPreferencesRoot() {
        return this.getSystemPreferencesRoot();
    }

    protected String toDebug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("arguments=");
        if (this.arguments != null) {
            buffer.append('[');
            int index = 0;
            while (index != this.arguments.length) {
                if (index != 0) {
                    buffer.append(',');
                }
                if (this.arguments[index] != null) {
                    buffer.append("\"" + this.arguments[index] + "\"");
                } else {
                    buffer.append("null");
                }
                ++index;
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
        buffer.append(",finished=" + this.finished);
        return buffer.toString();
    }
}

